# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Check for always cooperate or always defect in opponent's code
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"
    if always_defect:
        return "C"
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Round 10: Defect
    if current_round == 10:
        return "D"
    
    # Tit-for-Tat with Forgiveness
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "C"  # Forgive after two consecutive defections
    
    # Mirror the opponent's last move
    if opp_history:
        return opp_history[-1]
    
    # Default to cooperate if no history (shouldn't happen after Round 1)
    return "C"